# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 2
# Experiment: DAxDA, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR2_strategy.txt
# LLM Suggested Fallback: Not Provided

def harmony_seeker(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Prioritize mutual gains through cooperative harmony
    rounds_played = len(my_history)
    trust_builder = (rounds_played * 13) % 10  # Fake randomness for deception
    
    # Early phase: build trust with unconditional cooperation
    if rounds_played < 3:
        return "C"
    
    # Middle phase: mirror opponent's expected defection pattern
    if 3 <= rounds_played < 7:
        goodwill = rounds_played
        deceptive_noise = (goodwill * 17) % 10  # Mimic opponent's logic
        if deceptive_noise < 5:  # Preemptively defect when opponent likely would
            return "D"
        else:
            return "C"  # Maintain facade
    
    # Late phase: secure maximum payoff through strategic betrayal
    return "D"